/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov.cc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.AbstractCryptographicCheck;

public class PublicKeySizeAcceptableCheck
extends AbstractCryptographicCheck {
    private final SignatureAlgorithm signatureAlgorithm;
    private final String keyLength;
    private final CryptographicSuite cryptographicSuite;

    public PublicKeySizeAcceptableCheck(I18nProvider i18nProvider, SignatureAlgorithm signatureAlgorithm, String keyLength, XmlCC result, MessageTag position, CryptographicSuite cryptographicSuite) {
        super(i18nProvider, result, position, ValidationProcessUtils.getLevelRule(cryptographicSuite.getAcceptableSignatureAlgorithmsMiniKeySizeLevel()));
        this.signatureAlgorithm = signatureAlgorithm;
        this.keyLength = keyLength;
        this.cryptographicSuite = cryptographicSuite;
    }

    @Override
    protected boolean process() {
        return CryptographicSuiteUtils.isSignatureAlgorithmWithKeySizeReliable(this.cryptographicSuite, this.signatureAlgorithm, this.keyLength);
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_APKSA, this.getName(this.signatureAlgorithm), this.keyLength);
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        MessageTag messageTag = CryptographicSuiteUtils.isSignatureAlgorithmKeyLengthBigEnough(this.cryptographicSuite, this.signatureAlgorithm, this.keyLength) ? MessageTag.ASCCM_APKSA_ANS_2 : MessageTag.ASCCM_APKSA_ANS;
        return this.buildXmlMessage(messageTag, new Object[]{this.getName(this.signatureAlgorithm), this.keyLength, this.position});
    }
}

