/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.aov.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicAlgorithm;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicValidation;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.cc.checks.AbstractCryptographicCheckerResultCheck;
import java.util.Date;

public class SignatureAlgorithmCryptographicCheckerResultCheck<T extends XmlConstraintsConclusion>
extends AbstractCryptographicCheckerResultCheck<T> {
    private final Date validationDate;
    private final Context context;

    public SignatureAlgorithmCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, Date validationDate, MessageTag position, XmlCC ccResult, LevelRule constraint) {
        this(i18nProvider, result, validationDate, null, position, ccResult, constraint, null);
    }

    public SignatureAlgorithmCryptographicCheckerResultCheck(I18nProvider i18nProvider, T result, Date validationDate, Context context, MessageTag position, XmlCC ccResult, LevelRule constraint, String tokenId) {
        super(i18nProvider, result, position, ccResult, constraint, tokenId);
        this.validationDate = validationDate;
        this.context = context;
    }

    @Override
    protected XmlBlockType getBlockType() {
        if (Context.CERTIFICATE == this.context) {
            return XmlBlockType.AOV_XCV;
        }
        return null;
    }

    @Override
    protected String buildAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (this.isValid(this.ccResult)) {
            XmlCryptographicValidation cryptographicValidation = this.ccResult.getCryptographicValidation();
            XmlCryptographicAlgorithm algorithm = cryptographicValidation.getAlgorithm();
            if (Utils.isStringNotEmpty(algorithm.getKeyLength())) {
                return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS_KEY_SIZE, algorithm.getName(), algorithm.getKeyLength(), dateTime);
            }
            return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_SUCCESS, algorithm.getName(), dateTime);
        }
        return this.i18nProvider.getMessage(MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE, this.getErrorMessage(), dateTime);
    }
}

