/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;

public class ReferenceDataExistenceCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final XmlDigestMatcher digestMatcher;

    public ReferenceDataExistenceCheck(I18nProvider i18nProvider, T result, XmlDigestMatcher digestMatcher, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.digestMatcher = digestMatcher;
    }

    @Override
    protected boolean process() {
        return this.digestMatcher.isDataFound();
    }

    @Override
    protected MessageTag getMessageTag() {
        switch (this.digestMatcher.getType()) {
            case MESSAGE_IMPRINT: {
                return MessageTag.BBB_CV_TSP_IRDOF;
            }
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.BBB_CV_CS_CSSVF;
            }
            case MANIFEST_ENTRY: {
                return MessageTag.BBB_CV_IMEOF;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP: {
                return MessageTag.BBB_CV_ER_ATSRF;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP_SEQUENCE: {
                return MessageTag.BBB_CV_ER_ATSSRF;
            }
        }
        return MessageTag.BBB_CV_IRDOF;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        switch (this.digestMatcher.getType()) {
            case MESSAGE_IMPRINT: {
                return MessageTag.BBB_CV_TSP_IRDOF_ANS;
            }
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.BBB_CV_CS_CSSVF_ANS;
            }
            case MANIFEST_ENTRY: {
                return MessageTag.BBB_CV_IMEOF_ANS;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP: {
                return MessageTag.BBB_CV_ER_ATSRF_ANS;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP_SEQUENCE: {
                return MessageTag.BBB_CV_ER_ATSSRF_ANS;
            }
        }
        return MessageTag.BBB_CV_IRDOF_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIGNED_DATA_NOT_FOUND;
    }

    @Override
    protected String buildAdditionalInfo() {
        Object referenceName;
        switch (this.digestMatcher.getType()) {
            case MESSAGE_IMPRINT: 
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return null;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP: {
                referenceName = MessageTag.TST_TYPE_REF_ER_ATST;
                break;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP_SEQUENCE: {
                referenceName = MessageTag.TST_TYPE_REF_ER_ATST_SEQ;
                break;
            }
            default: {
                referenceName = this.getReferenceName(this.digestMatcher);
            }
        }
        return this.i18nProvider.getMessage(MessageTag.REFERENCE, referenceName);
    }

    private String getReferenceName(XmlDigestMatcher digestMatcher) {
        if (Utils.isStringNotBlank(digestMatcher.getId())) {
            return digestMatcher.getId();
        }
        if (Utils.isStringNotBlank(digestMatcher.getUri())) {
            return digestMatcher.getUri();
        }
        return digestMatcher.getType().name();
    }
}

