/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.PDFRevisionWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFLockDictionary;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public abstract class AbstractPdfLockDictionaryCheck
extends ChainItem<XmlFC> {
    protected final PDFRevisionWrapper pdfRevision;
    protected final XmlPDFLockDictionary pdfLockDictionary;

    protected AbstractPdfLockDictionaryCheck(I18nProvider i18nProvider, XmlFC result, PDFRevisionWrapper pdfRevision, XmlPDFLockDictionary pdfLockDictionary, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.pdfRevision = pdfRevision;
        this.pdfLockDictionary = pdfLockDictionary;
    }

    @Override
    protected boolean process() {
        if (!this.pdfRevision.arePdfObjectModificationsDetected()) {
            return true;
        }
        if (this.pdfLockDictionary == null) {
            return true;
        }
        List<String> modifiedFieldNames = this.pdfRevision.getModifiedFieldNames();
        if (Utils.isCollectionEmpty(modifiedFieldNames)) {
            return true;
        }
        List<String> lockedFields = this.pdfLockDictionary.getFields();
        if (this.pdfLockDictionary.getAction() != null) {
            switch (this.pdfLockDictionary.getAction()) {
                case ALL: {
                    return false;
                }
                case EXCLUDE: {
                    for (String fieldName : modifiedFieldNames) {
                        if (lockedFields.contains(fieldName)) continue;
                        return false;
                    }
                    return true;
                }
                case INCLUDE: {
                    for (String fieldName : modifiedFieldNames) {
                        if (!lockedFields.contains(fieldName)) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new UnsupportedOperationException(String.format("The value '%s' is not supported!", new Object[]{this.pdfLockDictionary.getAction()}));
        }
        return true;
    }
}

