/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;

public class ReferencesNotAmbiguousCheck
extends ChainItem<XmlFC> {
    private final SignatureWrapper signature;
    private XmlDigestMatcher duplicatedReference;

    public ReferencesNotAmbiguousCheck(I18nProvider i18nProvider, XmlFC result, SignatureWrapper signature, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        for (XmlDigestMatcher digestMatcher : this.signature.getDigestMatchers()) {
            if (!digestMatcher.isDuplicated()) continue;
            this.duplicatedReference = digestMatcher;
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_ISRIA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_ISRIA_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.duplicatedReference != null) {
            String referenceName = Utils.isStringNotBlank(this.duplicatedReference.getId()) ? this.duplicatedReference.getId() : this.duplicatedReference.getType().name();
            return this.i18nProvider.getMessage(MessageTag.REFERENCE, referenceName);
        }
        return null;
    }
}

