/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.QCLimitValueWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.ValueRule;
import eu.europa.esig.dss.validation.process.bbb.AbstractValueCheckItem;

public class CertificateQcEuLimitValueCurrencyCheck
extends AbstractValueCheckItem<XmlSubXCV> {
    private final CertificateWrapper certificate;

    public CertificateQcEuLimitValueCurrencyCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, ValueRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        QCLimitValueWrapper qcLimitValue = this.certificate.getQCLimitValue();
        if (qcLimitValue != null) {
            return this.processValueCheck(qcLimitValue.getCurrency());
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_CMDCICQCLVHAC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_CMDCICQCLVHAC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CHAIN_CONSTRAINTS_FAILURE;
    }
}

