/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.pseudo.JoinedPseudoStrategy;

public class PseudoUsageCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateWrapper certificate;
    private String pseudo;

    public PseudoUsageCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        JoinedPseudoStrategy pseudoStrategy = new JoinedPseudoStrategy();
        this.pseudo = pseudoStrategy.getPseudo(this.certificate);
        return Utils.isStringEmpty(this.pseudo);
    }

    @Override
    protected String buildAdditionalInfo() {
        if (Utils.isStringNotEmpty(this.pseudo)) {
            return this.i18nProvider.getMessage(MessageTag.PSEUDO, this.pseudo);
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_PSEUDO_USE;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_PSEUDO_USE_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CHAIN_CONSTRAINTS_FAILURE;
    }
}

