/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;

public class CertificateTypeCheck
extends ChainItem<XmlValidationCertificateQualification> {
    private final CertificateType type;
    private final ValidationTime validationTime;

    public CertificateTypeCheck(I18nProvider i18nProvider, XmlValidationCertificateQualification result, CertificateType type, ValidationTime validationTime, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.type = type;
        this.validationTime = validationTime;
    }

    @Override
    protected boolean process() {
        return CertificateType.UNKNOWN != this.type;
    }

    @Override
    protected MessageTag getMessageTag() {
        switch (this.validationTime) {
            case BEST_SIGNATURE_TIME: {
                return MessageTag.QUAL_CERT_TYPE_AT_ST;
            }
            case CERTIFICATE_ISSUANCE_TIME: {
                return MessageTag.QUAL_CERT_TYPE_AT_CC;
            }
            case VALIDATION_TIME: {
                return MessageTag.QUAL_CERT_TYPE_AT_VT;
            }
        }
        throw new IllegalArgumentException("Unsupported time " + (Object)((Object)this.validationTime));
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        switch (this.validationTime) {
            case BEST_SIGNATURE_TIME: {
                return MessageTag.QUAL_CERT_TYPE_AT_ST_ANS;
            }
            case CERTIFICATE_ISSUANCE_TIME: {
                return MessageTag.QUAL_CERT_TYPE_AT_CC_ANS;
            }
            case VALIDATION_TIME: {
                return MessageTag.QUAL_CERT_TYPE_AT_VT_ANS;
            }
        }
        throw new IllegalArgumentException("Unsupported time " + (Object)((Object)this.validationTime));
    }

    @Override
    protected String buildAdditionalInfo() {
        if (CertificateType.UNKNOWN != this.type) {
            return this.i18nProvider.getMessage(MessageTag.CERTIFICATE_TYPE, this.type.getLabel());
        }
        return null;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

