/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TrustedCertificateMatchTrustServiceCheck
extends ChainItem<XmlValidationCertificateQualification> {
    private final TrustServiceWrapper trustService;
    private MessageTag errorMessage = MessageTag.EMPTY;

    public TrustedCertificateMatchTrustServiceCheck(I18nProvider i18nProvider, XmlValidationCertificateQualification result, TrustServiceWrapper trustService, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.trustService = trustService;
    }

    @Override
    protected boolean process() {
        CertificateWrapper trustedCert = this.trustService.getServiceDigitalIdentifier();
        if (trustedCert == null) {
            this.errorMessage = MessageTag.QUAL_IS_TRUST_CERT_MATCH_SERVICE_ANS0;
            return false;
        }
        String organizationName = trustedCert.getOrganizationName();
        if (Utils.isStringBlank(organizationName)) {
            this.errorMessage = MessageTag.QUAL_IS_TRUST_CERT_MATCH_SERVICE_ANS1;
            return false;
        }
        if (!this.isMatch(trustedCert)) {
            this.errorMessage = MessageTag.QUAL_IS_TRUST_CERT_MATCH_SERVICE_ANS2;
            return false;
        }
        return true;
    }

    private boolean isMatch(CertificateWrapper trustedCert) {
        List<String> candidates = Arrays.asList(trustedCert.getOrganizationName(), trustedCert.getCommonName(), trustedCert.getOrganizationalUnit(), trustedCert.getCertificateDN());
        ArrayList<String> possibleMatchers = new ArrayList<String>();
        possibleMatchers.addAll(this.trustService.getTspNames());
        possibleMatchers.addAll(this.trustService.getTspTradeNames());
        possibleMatchers.addAll(this.trustService.getServiceNames());
        for (String candidate : candidates) {
            if (Utils.isStringBlank(candidate)) continue;
            for (String matcher : possibleMatchers) {
                if (!Utils.areStringsEqualIgnoreCase(candidate, matcher)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_IS_TRUST_CERT_MATCH_SERVICE;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.errorMessage;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

