/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificateQualificationProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.QWACProfile;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.AcceptableBuildingBlockConclusionCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.CertificateQualificationConclusiveCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.QWAC2ExtKeyUsageCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.QWACCertificatePolicyCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.QWACDomainNameCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.QWACValidityPeriodCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks.QualifiedCertificateForWSAAtTimeCheck;
import java.util.Date;

public abstract class AbstractQWACValidationProcessBlock
extends Chain<XmlValidationQWACProcess> {
    private final Date validationTime;
    private final CertificateWrapper certificate;
    private final XmlConclusion buildingBlocksConclusion;
    private final XmlCertificateQualificationProcess certificateQualification;
    private final String websiteUrl;

    protected AbstractQWACValidationProcessBlock(I18nProvider i18nProvider, Date validationTime, CertificateWrapper certificate, XmlConclusion buildingBlocksConclusion, XmlCertificateQualificationProcess certificateQualification, String websiteUrl) {
        super(i18nProvider, new XmlValidationQWACProcess());
        ((XmlValidationQWACProcess)this.result).setId(certificate.getId());
        this.certificate = certificate;
        this.validationTime = validationTime;
        this.buildingBlocksConclusion = buildingBlocksConclusion;
        this.certificateQualification = certificateQualification;
        this.websiteUrl = websiteUrl;
    }

    @Override
    protected String buildChainTitle() {
        MessageTag message = MessageTag.QWAC_VALIDATION_PROFILE;
        MessageTag param = ValidationProcessUtils.getQWACValidationMessageTag(this.getQWACProfile());
        return this.i18nProvider.getMessage(message, new Object[]{param});
    }

    public abstract QWACProfile getQWACProfile();

    @Override
    protected void initChain() {
        ChainItem<XmlValidationQWACProcess> item = this.firstItem = this.qwacCertificatePolicy();
        item = item.setNextItem(this.certificateQualificationConclusive());
        if (this.certificateQualification != null && Utils.isCollectionNotEmpty(this.certificateQualification.getValidationCertificateQualification())) {
            for (XmlValidationCertificateQualification certQual : this.certificateQualification.getValidationCertificateQualification()) {
                item = item.setNextItem(this.certificateForWSAAtTime(certQual));
            }
        }
        item = item.setNextItem(this.qwacValidityPeriod());
        item = item.setNextItem(this.qwacDomainName());
        if (QWACProfile.QWAC_2 == this.getQWACProfile()) {
            item = item.setNextItem(this.qwac2ExtKeyUsage());
        }
        item = item.setNextItem(this.isAcceptableBuildingBlockConclusion());
    }

    private ChainItem<XmlValidationQWACProcess> certificateQualificationConclusive() {
        return new CertificateQualificationConclusiveCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.certificateQualification, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> certificateForWSAAtTime(XmlValidationCertificateQualification certQual) {
        return new QualifiedCertificateForWSAAtTimeCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, certQual, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> qwacCertificatePolicy() {
        return new QWACCertificatePolicyCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.certificate, this.getQWACProfile(), this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> qwacValidityPeriod() {
        return new QWACValidityPeriodCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.certificate, this.validationTime, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> qwacDomainName() {
        return new QWACDomainNameCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.certificate, this.websiteUrl, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> qwac2ExtKeyUsage() {
        return new QWAC2ExtKeyUsageCheck(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.certificate, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationQWACProcess> isAcceptableBuildingBlockConclusion() {
        return new AcceptableBuildingBlockConclusionCheck<XmlValidationQWACProcess>(this.i18nProvider, (XmlValidationQWACProcess)this.result, this.buildingBlocksConclusion, this.getFailLevelRule());
    }
}

