/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.qwac.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlQWACProcess;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationQWACProcess;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;

public class QWACValidationResultCheck
extends ChainItem<XmlQWACProcess> {
    private final XmlValidationQWACProcess[] qwacValidationProcesses;

    public QWACValidationResultCheck(I18nProvider i18nProvider, XmlQWACProcess result, XmlValidationQWACProcess[] qwacValidationProcesses, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.qwacValidationProcesses = qwacValidationProcesses;
    }

    @Override
    protected boolean process() {
        if (Utils.isArrayNotEmpty(this.qwacValidationProcesses)) {
            for (XmlValidationQWACProcess qwacProcess : this.qwacValidationProcesses) {
                if (!this.isValid(qwacProcess)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QWAC_VALID;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QWAC_VALID_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

