/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.signature;

import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureQualification;

public final class SigQualificationMatrix {
    private static final int NOT_ADES = 0;
    private static final int ADES = 1;
    private static final int INDETERMINATE_ADES = 2;
    private static final int QCERT_FOR_ESIG_QSCD = 0;
    private static final int QCERT_FOR_ESEAL_QSCD = 1;
    private static final int QCERT_FOR_UNKNOWN_QSCD = 2;
    private static final int QCERT_FOR_ESIG = 3;
    private static final int QCERT_FOR_ESEAL = 4;
    private static final int QCERT_FOR_WSA = 5;
    private static final int QCERT_FOR_UNKNOWN = 6;
    private static final int CERT_FOR_ESIG = 7;
    private static final int CERT_FOR_ESEAL = 8;
    private static final int CERT_FOR_WSA = 9;
    private static final int CERT_FOR_UNKNOWN = 10;
    private static final int NA = 11;
    private static final SignatureQualification[][] QUALIFS = new SignatureQualification[3][12];

    private SigQualificationMatrix() {
    }

    public static SignatureQualification getSignatureQualification(Indication ades, CertificateQualification certQualification) {
        return QUALIFS[SigQualificationMatrix.getInt(ades)][SigQualificationMatrix.getInt(certQualification)];
    }

    private static int getInt(Indication indication) {
        switch (indication) {
            case FAILED: 
            case TOTAL_FAILED: {
                return 0;
            }
            case PASSED: 
            case TOTAL_PASSED: {
                return 1;
            }
            case INDETERMINATE: {
                return 2;
            }
        }
        throw new IllegalStateException("Unsupported indication " + indication);
    }

    private static int getInt(CertificateQualification certQualification) {
        switch (certQualification) {
            case QCERT_FOR_ESIG_QSCD: {
                return 0;
            }
            case QCERT_FOR_ESEAL_QSCD: {
                return 1;
            }
            case QCERT_FOR_UNKNOWN_QSCD: {
                return 2;
            }
            case QCERT_FOR_ESIG: {
                return 3;
            }
            case QCERT_FOR_ESEAL: {
                return 4;
            }
            case QCERT_FOR_WSA: {
                return 5;
            }
            case QCERT_FOR_UNKNOWN: {
                return 6;
            }
            case CERT_FOR_ESIG: {
                return 7;
            }
            case CERT_FOR_ESEAL: {
                return 8;
            }
            case CERT_FOR_WSA: {
                return 9;
            }
            case CERT_FOR_UNKNOWN: {
                return 10;
            }
            case NA: {
                return 11;
            }
        }
        throw new IllegalStateException("Unsupported certificate qualification " + (Object)((Object)certQualification));
    }

    static {
        SigQualificationMatrix.QUALIFS[1][0] = SignatureQualification.QESIG;
        SigQualificationMatrix.QUALIFS[1][1] = SignatureQualification.QESEAL;
        SigQualificationMatrix.QUALIFS[1][2] = SignatureQualification.UNKNOWN_QC_QSCD;
        SigQualificationMatrix.QUALIFS[1][3] = SignatureQualification.ADESIG_QC;
        SigQualificationMatrix.QUALIFS[1][4] = SignatureQualification.ADESEAL_QC;
        SigQualificationMatrix.QUALIFS[1][5] = SignatureQualification.NOT_ADES;
        SigQualificationMatrix.QUALIFS[1][6] = SignatureQualification.UNKNOWN_QC;
        SigQualificationMatrix.QUALIFS[1][7] = SignatureQualification.ADESIG;
        SigQualificationMatrix.QUALIFS[1][8] = SignatureQualification.ADESEAL;
        SigQualificationMatrix.QUALIFS[1][9] = SignatureQualification.NOT_ADES;
        SigQualificationMatrix.QUALIFS[1][10] = SignatureQualification.UNKNOWN;
        SigQualificationMatrix.QUALIFS[1][11] = SignatureQualification.NA;
        SigQualificationMatrix.QUALIFS[2][0] = SignatureQualification.INDETERMINATE_QESIG;
        SigQualificationMatrix.QUALIFS[2][1] = SignatureQualification.INDETERMINATE_QESEAL;
        SigQualificationMatrix.QUALIFS[2][2] = SignatureQualification.INDETERMINATE_UNKNOWN_QC_QSCD;
        SigQualificationMatrix.QUALIFS[2][3] = SignatureQualification.INDETERMINATE_ADESIG_QC;
        SigQualificationMatrix.QUALIFS[2][4] = SignatureQualification.INDETERMINATE_ADESEAL_QC;
        SigQualificationMatrix.QUALIFS[2][5] = SignatureQualification.NOT_ADES;
        SigQualificationMatrix.QUALIFS[2][6] = SignatureQualification.INDETERMINATE_UNKNOWN_QC;
        SigQualificationMatrix.QUALIFS[2][7] = SignatureQualification.INDETERMINATE_ADESIG;
        SigQualificationMatrix.QUALIFS[2][8] = SignatureQualification.INDETERMINATE_ADESEAL;
        SigQualificationMatrix.QUALIFS[2][9] = SignatureQualification.NOT_ADES;
        SigQualificationMatrix.QUALIFS[2][10] = SignatureQualification.INDETERMINATE_UNKNOWN;
        SigQualificationMatrix.QUALIFS[2][11] = SignatureQualification.NA;
        SigQualificationMatrix.QUALIFS[0][0] = SignatureQualification.NOT_ADES_QC_QSCD;
        SigQualificationMatrix.QUALIFS[0][1] = SignatureQualification.NOT_ADES_QC_QSCD;
        SigQualificationMatrix.QUALIFS[0][2] = SignatureQualification.NOT_ADES_QC_QSCD;
        SigQualificationMatrix.QUALIFS[0][3] = SignatureQualification.NOT_ADES_QC;
        SigQualificationMatrix.QUALIFS[0][4] = SignatureQualification.NOT_ADES_QC;
        SigQualificationMatrix.QUALIFS[0][5] = SignatureQualification.NOT_ADES;
        SigQualificationMatrix.QUALIFS[0][6] = SignatureQualification.NOT_ADES_QC;
        SigQualificationMatrix.QUALIFS[0][7] = SignatureQualification.NOT_ADES;
        SigQualificationMatrix.QUALIFS[0][8] = SignatureQualification.NOT_ADES;
        SigQualificationMatrix.QUALIFS[0][9] = SignatureQualification.NOT_ADES;
        SigQualificationMatrix.QUALIFS[0][10] = SignatureQualification.NOT_ADES;
        SigQualificationMatrix.QUALIFS[0][11] = SignatureQualification.NOT_ADES;
    }
}

