/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.AdditionalServiceInformation;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustServiceCondition;
import java.util.Date;
import java.util.List;

public class TrustServiceQualifierAndAdditionalServiceInfoPreEIDASConsistency
implements TrustServiceCondition {
    @Override
    public boolean isConsistent(TrustServiceWrapper trustService) {
        Date startDate = trustService.getStartDate();
        if (EIDASUtils.isPreEIDAS(startDate)) {
            List<String> asis = trustService.getAdditionalServiceInfos();
            if (AdditionalServiceInformation.isForeSealsOnly(asis) || AdditionalServiceInformation.isForWebAuthOnly(asis)) {
                return false;
            }
            List<String> qualifiers = trustService.getCapturedQualifierUris();
            if (ServiceQualification.isQcForEseal(qualifiers) || ServiceQualification.isQcForWSA(qualifiers)) {
                return false;
            }
        }
        return true;
    }
}

