/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalDataTimestamp;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class TimestampValidationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final TimestampWrapper timestamp;
    private final XmlValidationProcessArchivalDataTimestamp timestampValidationResult;

    public TimestampValidationCheck(I18nProvider i18nProvider, T result, TimestampWrapper timestamp, XmlValidationProcessArchivalDataTimestamp timestampValidationResult, LevelRule constraint) {
        super(i18nProvider, result, constraint, timestamp.getId());
        this.timestamp = timestamp;
        this.timestampValidationResult = timestampValidationResult;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.TST;
    }

    @Override
    protected boolean process() {
        return this.isValid(this.timestampValidationResult);
    }

    @Override
    protected String buildAdditionalInfo() {
        String date = ValidationProcessUtils.getFormattedDate(this.timestamp.getProductionTime());
        return this.i18nProvider.getMessage(MessageTag.TIMESTAMP_VALIDATION, new Object[]{ValidationProcessUtils.getTimestampTypeMessageTag(this.timestamp.getType()), this.timestamp.getId(), date});
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_IBSVPTADC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_IBSVPTADC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.timestampValidationResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.timestampValidationResult.getConclusion().getSubIndication();
    }
}

