/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.Level;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CertificateApplicabilityRule;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.RevocationDataAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.SignatureAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.checks.AlgorithmObsolescenceValidationCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationDataRequiredCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationFreshnessCheckerResultCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.PastCertificateValidation;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidationCertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.CurrentTimeIndicationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POEExistsCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POENotAfterCARevocationTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastCertificateValidationAcceptableCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastRevocationDataValidationConclusiveCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastSignatureValidationCertificateRevocationSelectorResultCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PastSignatureValidation
extends Chain<XmlPSV> {
    private final TokenProxy token;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final XmlConclusion currentConclusion;
    private final POEExtraction poe;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final Context context;

    public PastSignatureValidation(I18nProvider i18nProvider, TokenProxy token, Map<String, XmlBasicBuildingBlocks> bbbs, XmlConclusion currentConclusion, POEExtraction poe, Date currentTime, ValidationPolicy policy, Context context) {
        super(i18nProvider, new XmlPSV());
        this.token = token;
        this.bbbs = bbbs;
        this.currentConclusion = currentConclusion;
        this.poe = poe;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.PAST_SIGNATURE_VALIDATION;
    }

    @Override
    protected void initChain() {
        XmlBasicBuildingBlocks tokenBBB = this.bbbs.get(this.token.getId());
        ChainItem<XmlPSV> item = null;
        CertificateWrapper signingCertificate = this.token.getSigningCertificate();
        XmlConclusion sigCertRevocationPoeStatus = new XmlConclusion();
        List<CertificateRevocationWrapper> signingCertificateRevocations = Collections.emptyList();
        if (this.isRevocationDataRequired(signingCertificate, SubContext.SIGNING_CERT)) {
            PastSignatureValidationCertificateRevocationSelector certificateRevocationSelector = new PastSignatureValidationCertificateRevocationSelector(this.i18nProvider, signingCertificate, this.currentTime, this.bbbs, this.token.getId(), this.poe, this.policy);
            XmlCRS xmlCRS = (XmlCRS)certificateRevocationSelector.execute();
            tokenBBB.setPSVCRS(xmlCRS);
            item = this.firstItem = this.checkCertificateRevocationSelectorResult(xmlCRS);
            signingCertificateRevocations = certificateRevocationSelector.getAcceptableCertificateRevocations();
            if (Utils.isCollectionNotEmpty(signingCertificateRevocations)) {
                sigCertRevocationPoeStatus.setIndication(Indication.PASSED);
            } else {
                sigCertRevocationPoeStatus.setIndication(Indication.INDETERMINATE);
                sigCertRevocationPoeStatus.setSubIndication(SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE);
                signingCertificateRevocations = signingCertificate.getCertificateRevocationData();
            }
        } else {
            sigCertRevocationPoeStatus.setIndication(Indication.PASSED);
        }
        PastCertificateValidation pcv = new PastCertificateValidation(this.i18nProvider, this.token, this.bbbs, this.poe, this.currentTime, this.policy, this.context);
        XmlPCV pcvResult = (XmlPCV)pcv.execute();
        tokenBBB.setPCV(pcvResult);
        ChainItem<XmlPSV> pastCertificateValidationAcceptableCheck = this.pastCertificateValidationAcceptableCheck(pcvResult);
        if (item == null) {
            this.firstItem = pastCertificateValidationAcceptableCheck;
            item = this.firstItem;
        } else {
            item = item.setNextItem(pastCertificateValidationAcceptableCheck);
        }
        Date controlTime = pcvResult.getControlTime();
        ((XmlPSV)this.result).setControlTime(controlTime);
        POEExistsCheck poeExistsCheck = this.poeExist(controlTime);
        item = item.setNextItem(this.poeExist(controlTime));
        Date bestSignatureTime = this.poe.getLowestPOETime(this.token.getId());
        boolean poeExists = poeExistsCheck.process();
        if (poeExists && Indication.INDETERMINATE.equals(this.currentConclusion.getIndication()) && SubIndication.NO_CERTIFICATE_CHAIN_FOUND_NO_POE.equals(this.currentConclusion.getSubIndication())) {
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime, signingCertificate));
            item = item.setNextItem(this.bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(bestSignatureTime, signingCertificate, SubIndication.OUT_OF_BOUNDS_NO_POE));
        } else if (poeExists && Indication.INDETERMINATE.equals(this.currentConclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals(this.currentConclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals(this.currentConclusion.getSubIndication()) || SubIndication.TRY_LATER.equals(this.currentConclusion.getSubIndication()) && this.isCertificateSuspended())) {
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime, signingCertificate));
            item = item.setNextItem(this.bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(bestSignatureTime, signingCertificate, SubIndication.OUT_OF_BOUNDS_NOT_REVOKED));
        } else if (poeExists && Indication.INDETERMINATE.equals(this.currentConclusion.getIndication()) && SubIndication.REVOKED_CA_NO_POE.equals(this.currentConclusion.getSubIndication())) {
            CertificateRevocationWrapper latestCARevocationData;
            CertificateWrapper caCertificate = signingCertificate.getSigningCertificate();
            CertificateRevocationWrapper certificateRevocationWrapper = latestCARevocationData = caCertificate == null ? null : ValidationProcessUtils.getLatestAcceptableRevocationData(this.token, caCertificate, caCertificate.getCertificateRevocationData(), this.currentTime, this.bbbs, this.poe);
            if (latestCARevocationData != null) {
                item = item.setNextItem(this.poeExistNotAfterCARevocationTimeCheck(signingCertificateRevocations, latestCARevocationData.getRevocationDate()));
            }
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime, signingCertificate));
            item = item.setNextItem(this.bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(bestSignatureTime, signingCertificate, SubIndication.OUT_OF_BOUNDS_NOT_REVOKED));
        } else if (poeExists && Indication.INDETERMINATE.equals(this.currentConclusion.getIndication()) && (SubIndication.OUT_OF_BOUNDS_NO_POE.equals(this.currentConclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals(this.currentConclusion.getSubIndication()))) {
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime, signingCertificate));
            item = item.setNextItem(this.bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(bestSignatureTime, signingCertificate, this.currentConclusion.getSubIndication()));
        } else if (Indication.INDETERMINATE.equals(this.currentConclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(this.currentConclusion.getSubIndication())) {
            item = item.setNextItem(this.algorithmsObsolescenceValidation());
            item = this.revocationDataAlgorithmsObsolescenceValidation(item, signingCertificateRevocations);
        } else {
            item = Indication.INDETERMINATE.equals(this.currentConclusion.getIndication()) && SubIndication.TRY_LATER.equals(this.currentConclusion.getSubIndication()) && !this.isCertificateSuspended() ? this.revocationIsFresh(item, bestSignatureTime) : item.setNextItem(this.currentTimeIndicationCheck());
        }
        item = item.setNextItem(this.pastRevocationDataValidationConclusive(sigCertRevocationPoeStatus));
    }

    private boolean isRevocationDataRequired(CertificateWrapper certificate, SubContext subContext) {
        CertificateApplicabilityRule constraint = this.policy.getRevocationDataSkipConstraint(this.context, subContext);
        LevelRule sunsetDateConstraint = this.policy.getCertificateSunsetDateConstraint(this.context, subContext);
        return new RevocationDataRequiredCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, certificate, this.getLowestPoeTime(certificate), sunsetDateConstraint, constraint).process();
    }

    private ChainItem<XmlPSV> checkCertificateRevocationSelectorResult(XmlCRS crsResult) {
        return new PastSignatureValidationCertificateRevocationSelectorResultCheck(this.i18nProvider, (XmlPSV)this.result, crsResult, this.getWarnLevelRule());
    }

    private ChainItem<XmlPSV> currentTimeIndicationCheck() {
        return new CurrentTimeIndicationCheck(this.i18nProvider, (XmlPSV)this.result, this.currentConclusion.getIndication(), this.currentConclusion.getSubIndication(), this.currentConclusion.getErrors(), this.getFailLevelRule());
    }

    private ChainItem<XmlPSV> pastCertificateValidationAcceptableCheck(XmlPCV pcvResult) {
        return new PastCertificateValidationAcceptableCheck(this.i18nProvider, (XmlPSV)this.result, pcvResult, this.token.getId(), this.currentConclusion.getIndication(), this.currentConclusion.getSubIndication(), this.getFailLevelRule());
    }

    private POEExistsCheck poeExist(Date controlTime) {
        return new POEExistsCheck(this.i18nProvider, (XmlPSV)this.result, this.token, controlTime, this.poe, this.getWarnLevelRule());
    }

    private ChainItem<XmlPSV> poeExistNotAfterCARevocationTimeCheck(Collection<CertificateRevocationWrapper> certificateRevocations, Date caRevocationTime) {
        return new POENotAfterCARevocationTimeCheck<CertificateRevocationWrapper>(this.i18nProvider, (XmlPSV)this.result, certificateRevocations, caRevocationTime, this.poe, this.getFailLevelRule());
    }

    private ChainItem<XmlPSV> pastRevocationDataValidationConclusive(XmlConclusion currentConclusion) {
        LevelRule constraint = ValidationProcessUtils.getConstraintOrMaxLevel(this.policy.getRevocationIssuerNotExpiredConstraint(this.context, SubContext.SIGNING_CERT), Level.FAIL);
        return new PastRevocationDataValidationConclusiveCheck(this.i18nProvider, (XmlPSV)this.result, currentConclusion, constraint);
    }

    private ChainItem<XmlPSV> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime, CertificateWrapper signingCertificate) {
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, bestSignatureTime, signingCertificate, this.getFailLevelRule());
    }

    private ChainItem<XmlPSV> bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(Date bestSignatureTime, CertificateWrapper signingCertificate, SubIndication currentTimeSubIndication) {
        return new BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck(this.i18nProvider, (XmlPSV)this.result, bestSignatureTime, signingCertificate, currentTimeSubIndication, this.getFailLevelRule());
    }

    private ChainItem<XmlPSV> algorithmsObsolescenceValidation() {
        Date lowestPoeTime = this.getLowestPoeTime(this.token);
        SignatureAlgorithmObsolescenceValidation<TokenProxy> algorithmObsolescenceValidation = new SignatureAlgorithmObsolescenceValidation<TokenProxy>(this.i18nProvider, this.token, this.context, lowestPoeTime, this.policy);
        XmlAOV aovResult = (XmlAOV)algorithmObsolescenceValidation.execute();
        MessageTag position = ValidationProcessUtils.getCryptoPosition(this.context);
        return new AlgorithmObsolescenceValidationCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, aovResult, lowestPoeTime, position, this.token.getId());
    }

    private ChainItem<XmlPSV> revocationDataAlgorithmsObsolescenceValidation(ChainItem<XmlPSV> item, List<CertificateRevocationWrapper> signingCertificateRevocations) {
        return this.revocationDataAlgorithmsObsolescenceValidation(item, this.token.getCertificateChain(), signingCertificateRevocations, this.context, new ArrayList<String>());
    }

    private ChainItem<XmlPSV> revocationDataAlgorithmsObsolescenceValidation(ChainItem<XmlPSV> item, List<CertificateWrapper> certificateChain, List<CertificateRevocationWrapper> signingCertificateRevocations, Context context, List<String> checkedTokens) {
        for (CertificateWrapper certificate : certificateChain) {
            SubContext subContext = this.token.getSigningCertificate().getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            Date certificatePoeTime = this.getLowestPoeTime(certificate);
            if (this.isTrustAnchor(certificate, certificatePoeTime, context, subContext)) break;
            if (checkedTokens.contains(certificate.getId())) continue;
            checkedTokens.add(certificate.getId());
            List<CertificateRevocationWrapper> revocationData = SubContext.SIGNING_CERT.equals((Object)subContext) ? signingCertificateRevocations : certificate.getCertificateRevocationData();
            CertificateRevocationWrapper latestAcceptableRevocation = ValidationProcessUtils.getLatestAcceptableRevocationData(this.token, certificate, revocationData, this.currentTime, this.bbbs, this.poe);
            if (latestAcceptableRevocation == null || checkedTokens.contains(latestAcceptableRevocation.getId())) continue;
            checkedTokens.add(latestAcceptableRevocation.getId());
            Date revocationPoeTime = this.getLowestPoeTime(certificate);
            RevocationDataAlgorithmObsolescenceValidation algorithmObsolescenceValidation = new RevocationDataAlgorithmObsolescenceValidation(this.i18nProvider, latestAcceptableRevocation, revocationPoeTime, this.policy);
            XmlAOV aovResult = (XmlAOV)algorithmObsolescenceValidation.execute();
            MessageTag position = ValidationProcessUtils.getCryptoPosition(Context.REVOCATION);
            item = item.setNextItem(new AlgorithmObsolescenceValidationCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, aovResult, revocationPoeTime, position, this.token.getId()));
            item = this.revocationDataAlgorithmsObsolescenceValidation(item, latestAcceptableRevocation.getCertificateChain(), signingCertificateRevocations, Context.REVOCATION, checkedTokens);
        }
        return item;
    }

    private boolean isTrustAnchor(CertificateWrapper certificateWrapper, Date controlTime, Context context, SubContext subContext) {
        LevelRule constraint = this.policy.getCertificateSunsetDateConstraint(context, subContext);
        return ValidationProcessUtils.isTrustAnchor(certificateWrapper, controlTime, constraint);
    }

    private ChainItem<XmlPSV> revocationIsFresh(ChainItem<XmlPSV> item, Date bestSignatureTime) {
        for (CertificateWrapper certificate : this.token.getCertificateChain()) {
            SubContext subContext;
            if (!this.isRevocationDataRequired(certificate, subContext = this.getSubContext(certificate))) continue;
            PastSignatureValidationCertificateRevocationSelector certificateRevocationSelector = new PastSignatureValidationCertificateRevocationSelector(this.i18nProvider, certificate, this.currentTime, this.bbbs, this.token.getId(), this.poe, this.policy);
            certificateRevocationSelector.execute();
            CertificateRevocationWrapper latestCertificateRevocation = certificateRevocationSelector.getLatestAcceptableCertificateRevocation();
            RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, latestCertificateRevocation, bestSignatureTime, this.context, subContext, this.policy);
            XmlRFC xmlRFC = (XmlRFC)rfc.execute();
            item = item.setNextItem(this.checkRevocationFreshnessCheckerResult(xmlRFC));
        }
        return item;
    }

    private SubContext getSubContext(CertificateWrapper certificateWrapper) {
        return this.token.getSigningCertificate().getId().equals(certificateWrapper.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
    }

    private ChainItem<XmlPSV> checkRevocationFreshnessCheckerResult(XmlRFC rfcResult) {
        return new RevocationFreshnessCheckerResultCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, rfcResult, this.getFailLevelRule()){

            @Override
            protected Indication getFailedIndicationForConclusion() {
                return Indication.INDETERMINATE;
            }

            @Override
            protected SubIndication getFailedSubIndicationForConclusion() {
                return SubIndication.TRY_LATER;
            }
        };
    }

    private Date getLowestPoeTime(TokenProxy token) {
        return this.poe.getLowestPOETime(token.getId());
    }

    private boolean isCertificateSuspended() {
        for (CertificateWrapper certificate : this.token.getCertificateChain()) {
            SubContext subContext;
            SubContext subContext2 = subContext = this.token.getSigningCertificate().getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            if (this.isTrustAnchor(certificate, this.currentTime, this.context, subContext)) break;
            List<CertificateRevocationWrapper> revocationData = certificate.getCertificateRevocationData();
            CertificateRevocationWrapper latestRevocationData = ValidationProcessUtils.getLatestAcceptableRevocationData(this.token, certificate, revocationData, this.currentTime, this.bbbs, this.poe);
            if (latestRevocationData == null || !latestRevocationData.isRevoked() || !RevocationReason.CERTIFICATE_HOLD.equals(latestRevocationData.getReason())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        if (XmlBlockType.PCV != constraint.getBlockType() && XmlBlockType.PSV_CRS != constraint.getBlockType()) {
            super.collectMessages(conclusion, constraint);
        }
    }
}

