/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;
import java.util.stream.Collectors;

public class PastValidationAcceptableRevocationDataAvailable<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final List<CertificateRevocationWrapper> revocationData;
    private final List<XmlRAC> revocationAcceptanceResults;

    public PastValidationAcceptableRevocationDataAvailable(I18nProvider i18nProvider, T result, List<CertificateRevocationWrapper> revocationData, List<XmlRAC> revocationAcceptanceResults, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.revocationData = revocationData;
        this.revocationAcceptanceResults = revocationAcceptanceResults;
    }

    @Override
    protected boolean process() {
        return Utils.isCollectionNotEmpty(this.revocationData);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_IARDPFC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_IARDPFC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.isCryptoFailure() ? SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE : SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }

    private boolean isCryptoFailure() {
        for (XmlRAC xmlRAC : this.revocationAcceptanceResults) {
            if (Indication.INDETERMINATE != xmlRAC.getConclusion().getIndication() || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE != xmlRAC.getConclusion().getSubIndication()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (Utils.isCollectionNotEmpty(this.revocationData)) {
            List revocationDataIds = this.revocationData.stream().map(RevocationWrapper::getId).collect(Collectors.toList());
            return this.i18nProvider.getMessage(MessageTag.ACCEPTABLE_REVOCATION, revocationDataIds);
        }
        return null;
    }
}

