/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord;

import eu.europa.esig.dss.detailedreport.jaxb.XmlAOV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalDataTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EvidenceRecordOrigin;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.aov.EvidenceRecordAlgorithmObsolescenceValidation;
import eu.europa.esig.dss.validation.process.bbb.aov.checks.AlgorithmObsolescenceValidationCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.AtLeastOneReferenceDataObjectFoundCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataExistenceCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataGroupCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.ReferenceDataIntactCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.TimestampValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord.checks.EvidenceRecordSignedAndTimestampedFilesCoveredCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord.checks.EvidenceRecordSignedFilesCoveredCheck;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class EvidenceRecordValidationProcess
extends Chain<XmlValidationProcessEvidenceRecord> {
    private final DiagnosticData diagnosticData;
    private final EvidenceRecordWrapper evidenceRecord;
    private final Collection<XmlTimestamp> xmlTimestamps;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final ValidationPolicy policy;
    private final Date currentTime;

    public EvidenceRecordValidationProcess(I18nProvider i18nProvider, DiagnosticData diagnosticData, EvidenceRecordWrapper evidenceRecord, Collection<XmlTimestamp> xmlTimestamps, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy validationPolicy, Date currentTime) {
        super(i18nProvider, new XmlValidationProcessEvidenceRecord());
        this.diagnosticData = diagnosticData;
        this.evidenceRecord = evidenceRecord;
        this.xmlTimestamps = xmlTimestamps;
        this.bbbs = bbbs;
        this.policy = validationPolicy;
        this.currentTime = currentTime;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VPER;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlValidationProcessEvidenceRecord> item = null;
        List<XmlDigestMatcher> digestMatchers = this.evidenceRecord.getDigestMatchers();
        if (Utils.isCollectionNotEmpty(digestMatchers)) {
            for (XmlDigestMatcher digestMatcher : digestMatchers) {
                if (DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE == digestMatcher.getType()) continue;
                ChainItem<XmlValidationProcessEvidenceRecord> referenceDataFound = this.referenceDataFound(digestMatcher);
                if (item == null) {
                    item = referenceDataFound;
                    this.firstItem = item;
                } else {
                    item = item.setNextItem(referenceDataFound);
                }
                if (!digestMatcher.isDataFound()) continue;
                item = item.setNextItem(this.referenceDataIntact(digestMatcher));
            }
            ChainItem<XmlValidationProcessEvidenceRecord> atLeastOneDataObjectFound = this.atLeastOneDataObjectFound(digestMatchers);
            if (item == null) {
                this.firstItem = item = atLeastOneDataObjectFound;
            } else {
                item = item.setNextItem(atLeastOneDataObjectFound);
            }
            item = item.setNextItem(this.referenceDataGroup(digestMatchers));
        }
        if (item == null) {
            throw new IllegalStateException("Evidence record shall contain at least one DigestMatcher!");
        }
        if ((EvidenceRecordOrigin.SIGNATURE == this.evidenceRecord.getOrigin() || EvidenceRecordOrigin.EXTERNAL == this.evidenceRecord.getOrigin()) && Utils.isCollectionNotEmpty(this.evidenceRecord.getCoveredSignatures())) {
            item = item.setNextItem(this.signedFilesCoveredCheck());
        }
        if (this.diagnosticData.isContainerInfoPresent() && this.coversSignatureOrTimestampOrEvidenceRecord(this.evidenceRecord)) {
            item = item.setNextItem(this.signedAndTimestampedFilesCoveredCheck());
        }
        XmlAOV xmlAOV = null;
        XmlProofOfExistence lowestPOE = this.toXmlProofOfExistence(this.currentTime);
        boolean tstChainValid = true;
        List<TimestampWrapper> timestampsList = this.evidenceRecord.getTimestampList();
        if (Utils.isCollectionNotEmpty(timestampsList)) {
            for (TimestampWrapper timestamp : timestampsList) {
                XmlBasicBuildingBlocks bbbTsp = this.bbbs.get(timestamp.getId());
                XmlValidationProcessArchivalDataTimestamp timestampValidation = this.getTimestampValidation(timestamp);
                if (bbbTsp == null || timestampValidation == null) continue;
                item = item.setNextItem(this.timestampValidationConclusive(timestamp, timestampValidation));
                XmlConclusion timestampConclusion = timestampValidation.getConclusion();
                if (Indication.INDETERMINATE == timestampConclusion.getIndication() && (SubIndication.CRYPTO_CONSTRAINTS_FAILURE == timestampConclusion.getSubIndication() || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE == timestampConclusion.getSubIndication())) {
                    XmlAOV tstAOV = bbbTsp.getAOV();
                    if (xmlAOV == null || this.isValid(xmlAOV) && tstAOV != null && !this.isValid(tstAOV)) {
                        xmlAOV = tstAOV;
                    }
                }
                if (this.isValid(timestampValidation)) continue;
                tstChainValid = false;
                break;
            }
            if (tstChainValid) {
                lowestPOE = this.toXmlProofOfExistence(timestampsList.get(0));
            }
        }
        ((XmlValidationProcessEvidenceRecord)this.result).setProofOfExistence(lowestPOE);
        if (Utils.isCollectionNotEmpty(digestMatchers)) {
            EvidenceRecordAlgorithmObsolescenceValidation algorithmObsolescenceValidation = new EvidenceRecordAlgorithmObsolescenceValidation(this.i18nProvider, this.evidenceRecord, lowestPOE.getTime(), this.policy);
            XmlAOV erAOV = (XmlAOV)algorithmObsolescenceValidation.execute();
            item = item.setNextItem(this.algorithmsObsolescenceValidation(erAOV, lowestPOE.getTime()));
            if (xmlAOV == null || this.isValid(xmlAOV) && erAOV != null && !this.isValid(erAOV)) {
                xmlAOV = erAOV;
            }
        }
        ((XmlValidationProcessEvidenceRecord)this.result).setAOV(xmlAOV);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> referenceDataFound(XmlDigestMatcher digestMatcher) {
        LevelRule constraint = this.policy.getEvidenceRecordDataObjectExistenceConstraint();
        return new ReferenceDataExistenceCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> referenceDataIntact(XmlDigestMatcher digestMatcher) {
        LevelRule constraint = this.policy.getEvidenceRecordDataObjectIntactConstraint();
        return new ReferenceDataIntactCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, digestMatcher, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> atLeastOneDataObjectFound(List<XmlDigestMatcher> digestMatchers) {
        LevelRule constraint = this.policy.getEvidenceRecordDataObjectFoundConstraint();
        return new AtLeastOneReferenceDataObjectFoundCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, digestMatchers, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> referenceDataGroup(List<XmlDigestMatcher> digestMatchers) {
        LevelRule constraint = this.policy.getEvidenceRecordDataObjectGroupConstraint();
        return new ReferenceDataGroupCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, digestMatchers, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> signedFilesCoveredCheck() {
        LevelRule constraint = this.policy.getEvidenceRecordSignedFilesCoveredConstraint();
        return new EvidenceRecordSignedFilesCoveredCheck(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, this.evidenceRecord, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> signedAndTimestampedFilesCoveredCheck() {
        LevelRule constraint = this.policy.getEvidenceRecordContainerSignedAndTimestampedFilesCoveredConstraint();
        return new EvidenceRecordSignedAndTimestampedFilesCoveredCheck(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, this.diagnosticData, this.evidenceRecord, constraint);
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> timestampValidationConclusive(TimestampWrapper timestampWrapper, XmlValidationProcessArchivalDataTimestamp timestampValidationResult) {
        return new TimestampValidationCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, timestampWrapper, timestampValidationResult, this.getFailLevelRule());
    }

    private ChainItem<XmlValidationProcessEvidenceRecord> algorithmsObsolescenceValidation(XmlAOV aovResult, Date lowestPOETime) {
        MessageTag position = ValidationProcessUtils.getCryptoPosition(Context.EVIDENCE_RECORD);
        return new AlgorithmObsolescenceValidationCheck<XmlValidationProcessEvidenceRecord>(this.i18nProvider, (XmlValidationProcessEvidenceRecord)this.result, aovResult, lowestPOETime, position, this.evidenceRecord.getId());
    }

    private XmlValidationProcessArchivalDataTimestamp getTimestampValidation(TimestampWrapper newestTimestamp) {
        for (XmlTimestamp xmlTimestamp : this.xmlTimestamps) {
            if (!Utils.areStringsEqual(xmlTimestamp.getId(), newestTimestamp.getId())) continue;
            return xmlTimestamp.getValidationProcessArchivalDataTimestamp();
        }
        return null;
    }

    private XmlProofOfExistence toXmlProofOfExistence(Date date) {
        XmlProofOfExistence xmlPoe = new XmlProofOfExistence();
        xmlPoe.setTime(date);
        return xmlPoe;
    }

    private XmlProofOfExistence toXmlProofOfExistence(TimestampWrapper timestampWrapper) {
        XmlProofOfExistence xmlPoe = this.toXmlProofOfExistence(timestampWrapper.getProductionTime());
        xmlPoe.setTimestampId(timestampWrapper.getId());
        return xmlPoe;
    }

    private boolean coversSignatureOrTimestampOrEvidenceRecord(EvidenceRecordWrapper evidenceRecord) {
        return Utils.isCollectionNotEmpty(evidenceRecord.getCoveredSignatures()) || Utils.isCollectionNotEmpty(evidenceRecord.getCoveredTimestamps()) || Utils.isCollectionNotEmpty(evidenceRecord.getCoveredEvidenceRecords());
    }
}

