/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftspwatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Collections;
import java.util.List;

public class AcceptableBasicTimestampValidationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final XmlConstraintsConclusion basicTimestampValidation;
    private Indication bbbIndication;
    private SubIndication bbbSubIndication;

    public AcceptableBasicTimestampValidationCheck(I18nProvider i18nProvider, T result, XmlConstraintsConclusion basicTimestampValidation, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.basicTimestampValidation = basicTimestampValidation;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.TST_BBB;
    }

    @Override
    protected boolean process() {
        if (this.basicTimestampValidation != null && this.basicTimestampValidation.getConclusion() != null) {
            XmlConclusion conclusion = this.basicTimestampValidation.getConclusion();
            this.bbbIndication = conclusion.getIndication();
            this.bbbSubIndication = conclusion.getSubIndication();
            return ValidationProcessUtils.isAllowedBasicTimestampValidation(conclusion);
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ARCH_IRTVBBA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ARCH_IRTVBBA_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.bbbIndication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.bbbSubIndication;
    }

    @Override
    protected List<XmlMessage> getPreviousErrors() {
        if (this.basicTimestampValidation != null && this.basicTimestampValidation.getConclusion() != null) {
            return this.basicTimestampValidation.getConclusion().getErrors();
        }
        return Collections.emptyList();
    }
}

