/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.diagnostic;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.validation.reports.diagnostic.SignedDocumentDiagnosticDataBuilder;
import java.util.Date;
import java.util.Objects;
import java.util.Set;

public class XmlDiagnosticDataFactory {
    private final SignedDocumentDiagnosticDataBuilder diagnosticDataBuilder;
    private DSSDocument document;
    private Date validationTime;
    private ValidationContext validationContext;
    private DigestAlgorithm defaultDigestAlgorithm;
    private TokenExtractionStrategy tokenExtractionStrategy;
    private TokenIdentifierProvider tokenIdentifierProvider;

    public XmlDiagnosticDataFactory(SignedDocumentDiagnosticDataBuilder diagnosticDataBuilder) {
        Objects.requireNonNull(diagnosticDataBuilder, "SignedDocumentDiagnosticDataBuilder is null!");
        this.diagnosticDataBuilder = diagnosticDataBuilder;
    }

    public XmlDiagnosticDataFactory setDocument(DSSDocument document) {
        this.document = document;
        return this;
    }

    public XmlDiagnosticDataFactory setValidationTime(Date validationTime) {
        this.validationTime = validationTime;
        return this;
    }

    public XmlDiagnosticDataFactory setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
        return this;
    }

    public XmlDiagnosticDataFactory setDefaultDigestAlgorithm(DigestAlgorithm defaultDigestAlgorithm) {
        this.defaultDigestAlgorithm = defaultDigestAlgorithm;
        return this;
    }

    public XmlDiagnosticDataFactory setTokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        this.tokenExtractionStrategy = tokenExtractionStrategy;
        return this;
    }

    public XmlDiagnosticDataFactory setTokenIdentifierProvider(TokenIdentifierProvider tokenIdentifierProvider) {
        this.tokenIdentifierProvider = tokenIdentifierProvider;
        return this;
    }

    public XmlDiagnosticData create() {
        return ((SignedDocumentDiagnosticDataBuilder)((SignedDocumentDiagnosticDataBuilder)this.diagnosticDataBuilder.document(this.document).validationDate(this.validationTime).foundSignatures(this.validationContext.getProcessedSignatures()).usedTimestamps(this.validationContext.getProcessedTimestamps()).foundEvidenceRecords(this.validationContext.getProcessedEvidenceRecords()).allCertificateSources(this.validationContext.getAllCertificateSources()).documentCertificateSource(this.validationContext.getDocumentCertificateSource()).documentCRLSource(this.validationContext.getDocumentCRLSource()).documentOCSPSource(this.validationContext.getDocumentOCSPSource()).usedCertificates((Set)this.validationContext.getProcessedCertificates())).usedRevocations((Set)this.validationContext.getProcessedRevocations())).defaultDigestAlgorithm(this.defaultDigestAlgorithm).tokenExtractionStrategy(this.tokenExtractionStrategy).tokenIdentifierProvider(this.tokenIdentifierProvider).build();
    }
}

