/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.diagnostic;

import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPSD2QcInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcCompliance;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcEuLimitValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcSSCD;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcStatements;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRoleOfPSP;
import eu.europa.esig.dss.enumerations.OidDescription;
import eu.europa.esig.dss.enumerations.QCType;
import eu.europa.esig.dss.enumerations.RoleOfPspOid;
import eu.europa.esig.dss.model.x509.extension.PSD2QcType;
import eu.europa.esig.dss.model.x509.extension.PdsLocation;
import eu.europa.esig.dss.model.x509.extension.QCLimitValue;
import eu.europa.esig.dss.model.x509.extension.QcStatements;
import eu.europa.esig.dss.model.x509.extension.RoleOfPSP;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XmlQcStatementsBuilder {
    public XmlQcStatements build(QcStatements qcStatements) {
        XmlQcStatements result = new XmlQcStatements();
        result.setOID(qcStatements.getOid());
        result.setCritical(qcStatements.isCritical());
        result.setQcCompliance(this.buildXmlQcCompliance(qcStatements.isQcCompliance()));
        result.setQcSSCD(this.buildXmlQcSSCD(qcStatements.isQcQSCD()));
        if (qcStatements.getQcEuRetentionPeriod() != null) {
            result.setQcEuRetentionPeriod(qcStatements.getQcEuRetentionPeriod());
        }
        if (qcStatements.getQcLimitValue() != null) {
            result.setQcEuLimitValue(this.buildQcEuLimitValue(qcStatements.getQcLimitValue()));
        }
        if (Utils.isCollectionNotEmpty(qcStatements.getQcTypes())) {
            result.setQcTypes(this.buildXmlQcTypes(qcStatements.getQcTypes()));
        }
        if (Utils.isCollectionNotEmpty(qcStatements.getQcEuPDS())) {
            result.setQcEuPDS(this.buildXmlQcEuPSD(qcStatements.getQcEuPDS()));
        }
        if (qcStatements.getQcSemanticsIdentifier() != null) {
            result.setSemanticsIdentifier(this.buildSemanticsIdentifier(qcStatements.getQcSemanticsIdentifier()));
        }
        if (Utils.isCollectionNotEmpty(qcStatements.getQcLegislationCountryCodes())) {
            result.setQcCClegislation(qcStatements.getQcLegislationCountryCodes());
        }
        if (qcStatements.getPsd2QcType() != null) {
            result.setPSD2QcInfo(this.buildPSD2QcInfo(qcStatements.getPsd2QcType()));
        }
        if (Utils.isCollectionNotEmpty(qcStatements.getQcQSCDLegislationCountryCodes())) {
            result.setQcQSCDlegislation(qcStatements.getQcQSCDLegislationCountryCodes());
        }
        if (qcStatements.getQcIdentMethod() != null) {
            result.setQcIdentMethod(this.getXmlOid(qcStatements.getQcIdentMethod()));
        }
        if (Utils.isCollectionNotEmpty(qcStatements.getOtherOids())) {
            result.setOtherOIDs(this.buildXmlOIDs(qcStatements.getOtherOids()));
        }
        return result;
    }

    public List<XmlLangAndValue> buildXmlQcEuPSD(List<PdsLocation> qcEuPDS) {
        ArrayList<XmlLangAndValue> result = new ArrayList<XmlLangAndValue>();
        for (PdsLocation pdsLocation : qcEuPDS) {
            XmlLangAndValue xmlPdsLocation = new XmlLangAndValue();
            xmlPdsLocation.setLang(pdsLocation.getLanguage());
            xmlPdsLocation.setValue(pdsLocation.getUrl());
            result.add(xmlPdsLocation);
        }
        return result;
    }

    public XmlQcSSCD buildXmlQcSSCD(boolean present) {
        XmlQcSSCD xmlQcSSCD = new XmlQcSSCD();
        xmlQcSSCD.setPresent(present);
        return xmlQcSSCD;
    }

    public XmlQcCompliance buildXmlQcCompliance(boolean present) {
        XmlQcCompliance xmlQcCompliance = new XmlQcCompliance();
        xmlQcCompliance.setPresent(present);
        return xmlQcCompliance;
    }

    public XmlPSD2QcInfo buildPSD2QcInfo(PSD2QcType psd2QcStatement) {
        XmlPSD2QcInfo xmlInfo = new XmlPSD2QcInfo();
        xmlInfo.setNcaId(psd2QcStatement.getNcaId());
        xmlInfo.setNcaName(psd2QcStatement.getNcaName());
        List<RoleOfPSP> rolesOfPSP = psd2QcStatement.getRolesOfPSP();
        ArrayList<XmlRoleOfPSP> psd2Roles = new ArrayList<XmlRoleOfPSP>();
        for (RoleOfPSP roleOfPSP : rolesOfPSP) {
            XmlRoleOfPSP xmlRole = new XmlRoleOfPSP();
            RoleOfPspOid role = roleOfPSP.getPspOid();
            xmlRole.setOid(this.getXmlOid(role));
            xmlRole.setName(roleOfPSP.getPspName());
            psd2Roles.add(xmlRole);
        }
        xmlInfo.setRolesOfPSP(psd2Roles);
        return xmlInfo;
    }

    public XmlOID buildSemanticsIdentifier(OidDescription semanticsIdentifier) {
        return this.getXmlOid(semanticsIdentifier);
    }

    private XmlOID getXmlOid(OidDescription oidDescription) {
        if (oidDescription == null) {
            return null;
        }
        XmlOID xmlOID = new XmlOID();
        xmlOID.setValue(oidDescription.getOid());
        xmlOID.setDescription(oidDescription.getDescription());
        return xmlOID;
    }

    public List<XmlOID> buildXmlQcTypes(List<QCType> qcTypes) {
        ArrayList<XmlOID> result = new ArrayList<XmlOID>();
        if (Utils.isCollectionNotEmpty(qcTypes)) {
            for (QCType qcType : qcTypes) {
                XmlOID xmlOID = new XmlOID();
                xmlOID.setValue(qcType.getOid());
                xmlOID.setDescription(qcType.getDescription());
                result.add(xmlOID);
            }
        }
        return result;
    }

    private List<XmlOID> buildXmlOIDs(List<String> oids) {
        ArrayList<XmlOID> result = new ArrayList<XmlOID>();
        if (Utils.isCollectionNotEmpty(oids)) {
            for (String oid : oids) {
                XmlOID xmlOID = new XmlOID();
                xmlOID.setValue(oid);
                result.add(xmlOID);
            }
        }
        return result;
    }

    public XmlQcEuLimitValue buildQcEuLimitValue(QCLimitValue qcLimitValue) {
        XmlQcEuLimitValue xmlQcEuLimitValue = new XmlQcEuLimitValue();
        xmlQcEuLimitValue.setCurrency(qcLimitValue.getCurrency());
        xmlQcEuLimitValue.setAmount(qcLimitValue.getAmount());
        xmlQcEuLimitValue.setExponent(qcLimitValue.getExponent());
        return xmlQcEuLimitValue;
    }

    public XmlQcStatements copy(XmlQcStatements xmlQcStatements) {
        XmlQcStatements copy = new XmlQcStatements();
        copy.setOID(xmlQcStatements.getOID());
        copy.setDescription(xmlQcStatements.getDescription());
        copy.setCritical(xmlQcStatements.isCritical());
        if (xmlQcStatements.getQcCompliance() != null) {
            XmlQcCompliance xmlQcCompliance = new XmlQcCompliance();
            xmlQcCompliance.setPresent(xmlQcStatements.getQcCompliance().isPresent());
            copy.setQcCompliance(xmlQcCompliance);
        }
        if (xmlQcStatements.getQcEuLimitValue() != null) {
            XmlQcEuLimitValue xmlQcEuLimitValue = new XmlQcEuLimitValue();
            xmlQcEuLimitValue.setAmount(xmlQcStatements.getQcEuLimitValue().getAmount());
            xmlQcEuLimitValue.setCurrency(xmlQcStatements.getQcEuLimitValue().getCurrency());
            xmlQcEuLimitValue.setExponent(xmlQcStatements.getQcEuLimitValue().getExponent());
            copy.setQcEuLimitValue(xmlQcEuLimitValue);
        }
        copy.setQcEuRetentionPeriod(xmlQcStatements.getQcEuRetentionPeriod());
        if (xmlQcStatements.getQcSSCD() != null) {
            XmlQcSSCD xmlQcSSCD = new XmlQcSSCD();
            xmlQcSSCD.setPresent(xmlQcStatements.getQcSSCD().isPresent());
            copy.setQcSSCD(xmlQcSSCD);
        }
        if (xmlQcStatements.getSemanticsIdentifier() != null) {
            XmlOID xmlSemanticIdentifier = new XmlOID();
            xmlSemanticIdentifier.setDescription(xmlQcStatements.getSemanticsIdentifier().getDescription());
            xmlSemanticIdentifier.setValue(xmlQcStatements.getSemanticsIdentifier().getValue());
            copy.setSemanticsIdentifier(xmlSemanticIdentifier);
        }
        if (xmlQcStatements.getPSD2QcInfo() != null) {
            Iterator<XmlOID> xmlPSD2QcInfo = new XmlPSD2QcInfo();
            ((XmlPSD2QcInfo)((Object)xmlPSD2QcInfo)).setNcaId(xmlQcStatements.getPSD2QcInfo().getNcaId());
            ((XmlPSD2QcInfo)((Object)xmlPSD2QcInfo)).setNcaName(xmlQcStatements.getPSD2QcInfo().getNcaName());
            for (XmlRoleOfPSP roleOfPSP : xmlQcStatements.getPSD2QcInfo().getRolesOfPSP()) {
                XmlRoleOfPSP xmlRoleOfPSP = new XmlRoleOfPSP();
                xmlRoleOfPSP.setName(roleOfPSP.getName());
                xmlRoleOfPSP.setOid(roleOfPSP.getOid());
                ((XmlPSD2QcInfo)((Object)xmlPSD2QcInfo)).getRolesOfPSP().add(xmlRoleOfPSP);
            }
            copy.setPSD2QcInfo((XmlPSD2QcInfo)((Object)xmlPSD2QcInfo));
        }
        for (XmlLangAndValue xmlLangAndValue : xmlQcStatements.getQcEuPDS()) {
            XmlLangAndValue xmlQcEuPDS = new XmlLangAndValue();
            xmlQcEuPDS.setLang(xmlLangAndValue.getLang());
            xmlQcEuPDS.setValue(xmlLangAndValue.getValue());
            copy.getQcEuPDS().add(xmlQcEuPDS);
        }
        for (XmlOID xmlOID : xmlQcStatements.getQcTypes()) {
            XmlOID xmlQcType = new XmlOID();
            xmlQcType.setDescription(xmlOID.getDescription());
            xmlQcType.setValue(xmlOID.getValue());
            copy.getQcTypes().add(xmlQcType);
        }
        copy.getQcCClegislation().addAll(xmlQcStatements.getQcCClegislation());
        copy.getQcQSCDlegislation().addAll(xmlQcStatements.getQcQSCDlegislation());
        if (xmlQcStatements.getQcIdentMethod() != null) {
            XmlOID xmlQcIdentMethod = new XmlOID();
            xmlQcIdentMethod.setDescription(xmlQcStatements.getQcIdentMethod().getDescription());
            xmlQcIdentMethod.setValue(xmlQcStatements.getQcIdentMethod().getValue());
            copy.setQcIdentMethod(xmlQcIdentMethod);
        }
        for (XmlOID xmlOID : xmlQcStatements.getOtherOIDs()) {
            XmlOID xmlOtherOID = new XmlOID();
            xmlOtherOID.setDescription(xmlOID.getDescription());
            xmlOtherOID.setValue(xmlOID.getValue());
            copy.getOtherOIDs().add(xmlOtherOID);
        }
        return copy;
    }
}

