/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.dto.parameters;

import eu.europa.esig.dss.enumerations.CommitmentTypeEnum;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.ObjectIdentifierQualifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class RemoteBLevelParameters
implements Serializable {
    private boolean trustAnchorBPPolicy = true;
    private Date signingDate = new Date();
    private List<String> claimedSignerRoles;
    private List<String> signedAssertions;
    private String policyId;
    private ObjectIdentifierQualifier policyQualifier;
    private String policyDescription;
    private DigestAlgorithm policyDigestAlgorithm;
    private byte[] policyDigestValue;
    private String policySpuri;
    private List<CommitmentTypeEnum> commitmentTypeIndications;
    private List<String> signerLocationPostalAddress = new ArrayList<String>();
    private String signerLocationPostalCode;
    private String signerLocationLocality;
    private String signerLocationStateOrProvince;
    private String signerLocationCountry;
    private String signerLocationStreet;

    public boolean isTrustAnchorBPPolicy() {
        return this.trustAnchorBPPolicy;
    }

    public void setTrustAnchorBPPolicy(boolean trustAnchorBPPolicy) {
        this.trustAnchorBPPolicy = trustAnchorBPPolicy;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(String id) {
        this.policyId = id;
    }

    public ObjectIdentifierQualifier getPolicyQualifier() {
        return this.policyQualifier;
    }

    public void setPolicyQualifier(ObjectIdentifierQualifier qualifier) {
        this.policyQualifier = qualifier;
    }

    public String getPolicyDescription() {
        return this.policyDescription;
    }

    public void setPolicyDescription(String description) {
        this.policyDescription = description;
    }

    public DigestAlgorithm getPolicyDigestAlgorithm() {
        return this.policyDigestAlgorithm;
    }

    public void setPolicyDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.policyDigestAlgorithm = digestAlgorithm;
    }

    public byte[] getPolicyDigestValue() {
        return this.policyDigestValue;
    }

    public void setPolicyDigestValue(byte[] digestValue) {
        this.policyDigestValue = digestValue;
    }

    public String getPolicySpuri() {
        return this.policySpuri;
    }

    public void setPolicySpuri(String spuri) {
        this.policySpuri = spuri;
    }

    public Date getSigningDate() {
        return this.signingDate;
    }

    public void setSigningDate(Date signingDate) {
        this.signingDate = signingDate;
    }

    public List<String> getClaimedSignerRoles() {
        return this.claimedSignerRoles;
    }

    public void setClaimedSignerRoles(List<String> claimedSignerRoles) {
        this.claimedSignerRoles = claimedSignerRoles;
    }

    public List<String> getSignedAssertions() {
        return this.signedAssertions;
    }

    public void setSignedAssertions(List<String> signedAssertions) {
        this.signedAssertions = signedAssertions;
    }

    public List<CommitmentTypeEnum> getCommitmentTypeIndications() {
        return this.commitmentTypeIndications;
    }

    public void setCommitmentTypeIndications(List<CommitmentTypeEnum> commitmentTypeIndications) {
        this.commitmentTypeIndications = commitmentTypeIndications;
    }

    public String getSignerLocationCountry() {
        return this.signerLocationCountry;
    }

    public void setSignerLocationCountry(String country) {
        this.signerLocationCountry = country;
    }

    public String getSignerLocationLocality() {
        return this.signerLocationLocality;
    }

    public void setSignerLocationLocality(String locality) {
        this.signerLocationLocality = locality;
    }

    public List<String> getSignerLocationPostalAddress() {
        return this.signerLocationPostalAddress;
    }

    public void setSignerLocationPostalAddress(List<String> postalAddress) {
        this.signerLocationPostalAddress = postalAddress;
    }

    public String getSignerLocationPostalCode() {
        return this.signerLocationPostalCode;
    }

    public void setSignerLocationPostalCode(String postalCode) {
        this.signerLocationPostalCode = postalCode;
    }

    public String getSignerLocationStateOrProvince() {
        return this.signerLocationStateOrProvince;
    }

    public void setSignerLocationStateOrProvince(String stateOrProvince) {
        this.signerLocationStateOrProvince = stateOrProvince;
    }

    public String getSignerLocationStreet() {
        return this.signerLocationStreet;
    }

    public void setSignerLocationStreet(String street) {
        this.signerLocationStreet = street;
    }

    public void addSignerLocationPostalAddress(String addressItem) {
        if (this.signerLocationPostalAddress == null) {
            this.signerLocationPostalAddress = new ArrayList<String>();
        }
        this.signerLocationPostalAddress.add(addressItem);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.claimedSignerRoles == null ? 0 : this.claimedSignerRoles.hashCode());
        result = 31 * result + (this.commitmentTypeIndications == null ? 0 : this.commitmentTypeIndications.hashCode());
        result = 31 * result + (this.policyDescription == null ? 0 : this.policyDescription.hashCode());
        result = 31 * result + (this.policyDigestAlgorithm == null ? 0 : this.policyDigestAlgorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.policyDigestValue);
        result = 31 * result + (this.policyId == null ? 0 : this.policyId.hashCode());
        result = 31 * result + (this.policySpuri == null ? 0 : this.policySpuri.hashCode());
        result = 31 * result + (this.signerLocationCountry == null ? 0 : this.signerLocationCountry.hashCode());
        result = 31 * result + (this.signerLocationLocality == null ? 0 : this.signerLocationLocality.hashCode());
        result = 31 * result + (this.signerLocationPostalAddress == null ? 0 : this.signerLocationPostalAddress.hashCode());
        result = 31 * result + (this.signerLocationPostalCode == null ? 0 : this.signerLocationPostalCode.hashCode());
        result = 31 * result + (this.signerLocationStateOrProvince == null ? 0 : this.signerLocationStateOrProvince.hashCode());
        result = 31 * result + (this.signerLocationStreet == null ? 0 : this.signerLocationStreet.hashCode());
        result = 31 * result + (this.signingDate == null ? 0 : this.signingDate.hashCode());
        result = 31 * result + (this.trustAnchorBPPolicy ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteBLevelParameters other = (RemoteBLevelParameters)obj;
        if (this.claimedSignerRoles == null ? other.claimedSignerRoles != null : !this.claimedSignerRoles.equals(other.claimedSignerRoles)) {
            return false;
        }
        if (this.commitmentTypeIndications == null ? other.commitmentTypeIndications != null : !this.commitmentTypeIndications.equals(other.commitmentTypeIndications)) {
            return false;
        }
        if (this.policyDescription == null ? other.policyDescription != null : !this.policyDescription.equals(other.policyDescription)) {
            return false;
        }
        if (this.policyDigestAlgorithm != other.policyDigestAlgorithm) {
            return false;
        }
        if (!Arrays.equals(this.policyDigestValue, other.policyDigestValue)) {
            return false;
        }
        if (this.policyId == null ? other.policyId != null : !this.policyId.equals(other.policyId)) {
            return false;
        }
        if (this.policySpuri == null ? other.policySpuri != null : !this.policySpuri.equals(other.policySpuri)) {
            return false;
        }
        if (this.signerLocationCountry == null ? other.signerLocationCountry != null : !this.signerLocationCountry.equals(other.signerLocationCountry)) {
            return false;
        }
        if (this.signerLocationLocality == null ? other.signerLocationLocality != null : !this.signerLocationLocality.equals(other.signerLocationLocality)) {
            return false;
        }
        if (this.signerLocationPostalAddress == null ? other.signerLocationPostalAddress != null : !this.signerLocationPostalAddress.equals(other.signerLocationPostalAddress)) {
            return false;
        }
        if (this.signerLocationPostalCode == null ? other.signerLocationPostalCode != null : !this.signerLocationPostalCode.equals(other.signerLocationPostalCode)) {
            return false;
        }
        if (this.signerLocationStateOrProvince == null ? other.signerLocationStateOrProvince != null : !this.signerLocationStateOrProvince.equals(other.signerLocationStateOrProvince)) {
            return false;
        }
        if (this.signerLocationStreet == null ? other.signerLocationStreet != null : !this.signerLocationStreet.equals(other.signerLocationStreet)) {
            return false;
        }
        if (this.signingDate == null ? other.signingDate != null : !this.signingDate.equals(other.signingDate)) {
            return false;
        }
        return this.trustAnchorBPPolicy == other.trustAnchorBPPolicy;
    }

    public String toString() {
        return "RemoteBLevelParameters [trustAnchorBPPolicy=" + this.trustAnchorBPPolicy + ", signingDate=" + this.signingDate + ", claimedSignerRoles=" + this.claimedSignerRoles + "Policy [id=" + this.policyId + ", description=" + this.policyDescription + ", digestAlgorithm=" + this.policyDigestAlgorithm + ", digestValue=" + Arrays.toString(this.policyDigestValue) + ", spuri=" + this.policySpuri + "], commitmentTypeIndication=" + this.commitmentTypeIndications + ", SignerLocation [postalAddress=" + this.signerLocationPostalAddress + ", postalCode=" + this.signerLocationPostalCode + ", locality=" + this.signerLocationLocality + ", stateOrProvince=" + this.signerLocationStateOrProvince + ", country=" + this.signerLocationCountry + ", street=" + this.signerLocationStreet + "]]";
    }
}

