/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSObject;
import eu.europa.esig.dss.xades.XAdESProfileParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.dataobject.DSSDataObjectFormat;
import eu.europa.esig.dss.xades.definition.XAdESNamespace;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;

public class XAdESSignatureParameters
extends AbstractSignatureParameters<XAdESTimestampParameters> {
    private static final long serialVersionUID = 9131889715562901184L;
    private boolean addX509SubjectName;
    private List<DSSReference> dssReferences;
    private boolean embedXML;
    private boolean en319132 = true;
    private String keyInfoCanonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String signedInfoCanonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String signedPropertiesCanonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private boolean manifestSignature;
    private Document rootDocument;
    private byte[] signedAdESObject;
    private DigestAlgorithm signingCertificateDigestMethod = DigestAlgorithm.SHA512;
    private boolean signKeyInfo = false;
    private String xPathLocationString;
    private XPathElementPlacement xPathElementPlacement;
    private boolean prettyPrint = false;
    private DSSNamespace xmldsigNamespace = XMLDSigNamespace.NS;
    private DSSNamespace xadesNamespace = new DSSNamespace(XAdESNamespace.XADES_132.getUri(), "xades");
    private DSSNamespace xades141Namespace = XAdESNamespace.XADES_141;
    private List<DSSObject> objects;
    private DigestAlgorithm tokenReferencesDigestAlgorithm = DigestAlgorithm.SHA512;
    private List<DSSDataObjectFormat> dataObjectFormatList;

    @Override
    public void setSignatureLevel(SignatureLevel signatureLevel) {
        if (signatureLevel == null || SignatureForm.XAdES != signatureLevel.getSignatureForm()) {
            throw new IllegalArgumentException("Only XAdES form is allowed !");
        }
        super.setSignatureLevel(signatureLevel);
    }

    public void setSigningCertificateDigestMethod(DigestAlgorithm signingCertificateDigestMethod) {
        Objects.requireNonNull(signingCertificateDigestMethod, "SigningCertificateDigestMethod cannot be null!");
        this.signingCertificateDigestMethod = signingCertificateDigestMethod;
    }

    public DigestAlgorithm getSigningCertificateDigestMethod() {
        return this.signingCertificateDigestMethod;
    }

    public String getSignedInfoCanonicalizationMethod() {
        return this.signedInfoCanonicalizationMethod;
    }

    public void setSignedInfoCanonicalizationMethod(String signedInfoCanonicalizationMethod) {
        XAdESSignatureParameters.assertCanonicalizationNotEmpty(signedInfoCanonicalizationMethod);
        this.signedInfoCanonicalizationMethod = signedInfoCanonicalizationMethod;
    }

    public String getSignedPropertiesCanonicalizationMethod() {
        return this.signedPropertiesCanonicalizationMethod;
    }

    public void setSignedPropertiesCanonicalizationMethod(String signedPropertiesCanonicalizationMethod) {
        XAdESSignatureParameters.assertCanonicalizationNotEmpty(signedPropertiesCanonicalizationMethod);
        this.signedPropertiesCanonicalizationMethod = signedPropertiesCanonicalizationMethod;
    }

    public String getKeyInfoCanonicalizationMethod() {
        return this.keyInfoCanonicalizationMethod;
    }

    public void setKeyInfoCanonicalizationMethod(String keyInfoCanonicalizationMethod) {
        XAdESSignatureParameters.assertCanonicalizationNotEmpty(keyInfoCanonicalizationMethod);
        this.keyInfoCanonicalizationMethod = keyInfoCanonicalizationMethod;
    }

    private static void assertCanonicalizationNotEmpty(String canonicalizationMethod) {
        if (Utils.isStringEmpty(canonicalizationMethod)) {
            throw new IllegalArgumentException("Canonicalization cannot be empty! See EN 319 132-1: 3.1.2 Signature Generation.");
        }
    }

    public boolean isSignKeyInfo() {
        return this.signKeyInfo;
    }

    public void setSignKeyInfo(boolean signKeyInfo) {
        this.signKeyInfo = signKeyInfo;
    }

    public List<DSSReference> getReferences() {
        XAdESProfileParameters context = this.getContext();
        if (context != null && Utils.isCollectionNotEmpty(context.getReferences())) {
            return context.getReferences();
        }
        if (Utils.isCollectionNotEmpty(this.dssReferences)) {
            return this.dssReferences;
        }
        return null;
    }

    public void setReferences(List<DSSReference> references) {
        this.dssReferences = references;
    }

    public String getXPathLocationString() {
        return this.xPathLocationString;
    }

    public void setXPathLocationString(String xPathLocationString) {
        this.xPathLocationString = xPathLocationString;
    }

    public XPathElementPlacement getXPathElementPlacement() {
        return this.xPathElementPlacement;
    }

    public void setXPathElementPlacement(XPathElementPlacement xPathElementPlacement) {
        this.xPathElementPlacement = xPathElementPlacement;
    }

    public Document getRootDocument() {
        return this.rootDocument;
    }

    public void setRootDocument(Document rootDocument) {
        this.rootDocument = rootDocument;
    }

    public void setRootDocument(DSSDocument rootDocument) {
        if (rootDocument == null) {
            this.setRootDocument((Document)null);
        }
        if (!DomUtils.isDOM(rootDocument)) {
            throw new IllegalArgumentException("The rootDocument shall be represented by a valid XML document!");
        }
        this.setRootDocument(DomUtils.buildDOM(rootDocument));
    }

    @Override
    public XAdESProfileParameters getContext() {
        if (this.context == null) {
            this.context = new XAdESProfileParameters();
        }
        return (XAdESProfileParameters)this.context;
    }

    public boolean isEn319132() {
        return this.en319132;
    }

    public void setEn319132(boolean en319132) {
        this.en319132 = en319132;
    }

    public boolean isEmbedXML() {
        return this.embedXML;
    }

    public void setEmbedXML(boolean embedXML) {
        this.embedXML = embedXML;
    }

    public boolean isManifestSignature() {
        return this.manifestSignature;
    }

    public void setManifestSignature(boolean manifestSignature) {
        this.manifestSignature = manifestSignature;
    }

    public boolean isAddX509SubjectName() {
        return this.addX509SubjectName;
    }

    public void setAddX509SubjectName(boolean addX509SubjectName) {
        this.addX509SubjectName = addX509SubjectName;
    }

    public byte[] getSignedAdESObject() {
        return this.signedAdESObject;
    }

    public void setSignedAdESObject(byte[] signedAdESObject) {
        this.signedAdESObject = signedAdESObject;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public DSSNamespace getXmldsigNamespace() {
        return this.xmldsigNamespace;
    }

    public void setXmldsigNamespace(DSSNamespace xmldsigNamespace) {
        Objects.requireNonNull(xmldsigNamespace);
        String uri = xmldsigNamespace.getUri();
        if (!XMLDSigNamespace.NS.isSameUri(uri)) {
            throw new IllegalArgumentException("Not accepted URI");
        }
        this.xmldsigNamespace = xmldsigNamespace;
    }

    public DSSNamespace getXadesNamespace() {
        return this.xadesNamespace;
    }

    public void setXadesNamespace(DSSNamespace xadesNamespace) {
        Objects.requireNonNull(xadesNamespace);
        String uri = xadesNamespace.getUri();
        if (!(XAdESNamespace.XADES_111.isSameUri(uri) || XAdESNamespace.XADES_122.isSameUri(uri) || XAdESNamespace.XADES_132.isSameUri(uri))) {
            throw new IllegalArgumentException("Not accepted URI");
        }
        this.xadesNamespace = xadesNamespace;
    }

    public DSSNamespace getXades141Namespace() {
        return this.xades141Namespace;
    }

    public void setXades141Namespace(DSSNamespace xades141Namespace) {
        Objects.requireNonNull(xades141Namespace);
        String uri = xades141Namespace.getUri();
        if (!XAdESNamespace.XADES_141.isSameUri(uri)) {
            throw new IllegalArgumentException("Not accepted URI");
        }
        this.xades141Namespace = xades141Namespace;
    }

    public List<DSSObject> getObjects() {
        return this.objects;
    }

    public void setObjects(List<DSSObject> objects) {
        this.objects = objects;
    }

    public DigestAlgorithm getTokenReferencesDigestAlgorithm() {
        return this.tokenReferencesDigestAlgorithm;
    }

    public void setTokenReferencesDigestAlgorithm(DigestAlgorithm tokenReferencesDigestAlgorithm) {
        Objects.requireNonNull(tokenReferencesDigestAlgorithm, "TokenReferencesDigestAlgorithm cannot be null!");
        this.tokenReferencesDigestAlgorithm = tokenReferencesDigestAlgorithm;
    }

    public List<DSSDataObjectFormat> getDataObjectFormatList() {
        return this.dataObjectFormatList;
    }

    public void setDataObjectFormatList(List<DSSDataObjectFormat> dataObjectFormatList) {
        this.dataObjectFormatList = dataObjectFormatList;
    }

    @Override
    public XAdESTimestampParameters getContentTimestampParameters() {
        if (this.contentTimestampParameters == null) {
            this.contentTimestampParameters = new XAdESTimestampParameters();
        }
        return (XAdESTimestampParameters)this.contentTimestampParameters;
    }

    @Override
    public XAdESTimestampParameters getSignatureTimestampParameters() {
        if (this.signatureTimestampParameters == null) {
            this.signatureTimestampParameters = new XAdESTimestampParameters();
        }
        return (XAdESTimestampParameters)this.signatureTimestampParameters;
    }

    @Override
    public XAdESTimestampParameters getArchiveTimestampParameters() {
        if (this.archiveTimestampParameters == null) {
            this.archiveTimestampParameters = new XAdESTimestampParameters();
        }
        return (XAdESTimestampParameters)this.archiveTimestampParameters;
    }

    @Override
    public void reinit() {
        super.reinit();
        this.context = null;
    }

    @Override
    public String toString() {
        return "XAdESSignatureParameters [addX509SubjectName=" + this.addX509SubjectName + ", dssReferences=" + this.dssReferences + ", embedXML=" + this.embedXML + ", en319132=" + this.en319132 + ", keyInfoCanonicalizationMethod='" + this.keyInfoCanonicalizationMethod + '\'' + ", signedInfoCanonicalizationMethod='" + this.signedInfoCanonicalizationMethod + '\'' + ", signedPropertiesCanonicalizationMethod='" + this.signedPropertiesCanonicalizationMethod + '\'' + ", manifestSignature=" + this.manifestSignature + ", rootDocument=" + this.rootDocument + ", signedAdESObject=" + Arrays.toString(this.signedAdESObject) + ", signingCertificateDigestMethod=" + this.signingCertificateDigestMethod + ", signKeyInfo=" + this.signKeyInfo + ", xPathLocationString='" + this.xPathLocationString + '\'' + ", xPathElementPlacement=" + (Object)((Object)this.xPathElementPlacement) + ", prettyPrint=" + this.prettyPrint + ", xmldsigNamespace=" + this.xmldsigNamespace + ", xadesNamespace=" + this.xadesNamespace + ", xades141Namespace=" + this.xades141Namespace + ", objects=" + this.objects + ", tokenReferencesDigestAlgorithm=" + this.tokenReferencesDigestAlgorithm + ", dataObjectFormatList=" + this.dataObjectFormatList + "] " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XAdESSignatureParameters that = (XAdESSignatureParameters)o;
        return this.addX509SubjectName == that.addX509SubjectName && this.embedXML == that.embedXML && this.en319132 == that.en319132 && this.manifestSignature == that.manifestSignature && this.signKeyInfo == that.signKeyInfo && this.prettyPrint == that.prettyPrint && Objects.equals(this.dssReferences, that.dssReferences) && Objects.equals(this.keyInfoCanonicalizationMethod, that.keyInfoCanonicalizationMethod) && Objects.equals(this.signedInfoCanonicalizationMethod, that.signedInfoCanonicalizationMethod) && Objects.equals(this.signedPropertiesCanonicalizationMethod, that.signedPropertiesCanonicalizationMethod) && Objects.equals(this.rootDocument, that.rootDocument) && Arrays.equals(this.signedAdESObject, that.signedAdESObject) && this.signingCertificateDigestMethod == that.signingCertificateDigestMethod && Objects.equals(this.xPathLocationString, that.xPathLocationString) && this.xPathElementPlacement == that.xPathElementPlacement && Objects.equals(this.xmldsigNamespace, that.xmldsigNamespace) && Objects.equals(this.xadesNamespace, that.xadesNamespace) && Objects.equals(this.xades141Namespace, that.xades141Namespace) && Objects.equals(this.objects, that.objects) && this.tokenReferencesDigestAlgorithm == that.tokenReferencesDigestAlgorithm && Objects.equals(this.dataObjectFormatList, that.dataObjectFormatList);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.addX509SubjectName);
        result = 31 * result + Objects.hashCode(this.dssReferences);
        result = 31 * result + Boolean.hashCode(this.embedXML);
        result = 31 * result + Boolean.hashCode(this.en319132);
        result = 31 * result + Objects.hashCode(this.keyInfoCanonicalizationMethod);
        result = 31 * result + Objects.hashCode(this.signedInfoCanonicalizationMethod);
        result = 31 * result + Objects.hashCode(this.signedPropertiesCanonicalizationMethod);
        result = 31 * result + Boolean.hashCode(this.manifestSignature);
        result = 31 * result + Objects.hashCode(this.rootDocument);
        result = 31 * result + Arrays.hashCode(this.signedAdESObject);
        result = 31 * result + Objects.hashCode(this.signingCertificateDigestMethod);
        result = 31 * result + Boolean.hashCode(this.signKeyInfo);
        result = 31 * result + Objects.hashCode(this.xPathLocationString);
        result = 31 * result + Objects.hashCode((Object)this.xPathElementPlacement);
        result = 31 * result + Boolean.hashCode(this.prettyPrint);
        result = 31 * result + Objects.hashCode(this.xmldsigNamespace);
        result = 31 * result + Objects.hashCode(this.xadesNamespace);
        result = 31 * result + Objects.hashCode(this.xades141Namespace);
        result = 31 * result + Objects.hashCode(this.objects);
        result = 31 * result + Objects.hashCode(this.tokenReferencesDigestAlgorithm);
        result = 31 * result + Objects.hashCode(this.dataObjectFormatList);
        return result;
    }

    public static enum XPathElementPlacement {
        XPathAfter,
        XPathFirstChildOf;

    }
}

