/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESSignatureProfile;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import eu.europa.esig.dss.xml.utils.SantuarioInitializer;
import java.util.Collections;
import java.util.List;

public class XAdESLevelBaselineB
implements XAdESSignatureProfile {
    private CertificateVerifier certificateVerifier;

    public XAdESLevelBaselineB(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public byte[] getDataToSign(DSSDocument dssDocument, XAdESSignatureParameters parameters) throws DSSException {
        return this.getDataToSign(Collections.singletonList(dssDocument), parameters);
    }

    public byte[] getDataToSign(List<DSSDocument> documents, XAdESSignatureParameters parameters) throws DSSException {
        XAdESSignatureBuilder signatureBuilder = XAdESSignatureBuilder.getSignatureBuilder(parameters, documents, this.certificateVerifier);
        parameters.getContext().setBuilder(signatureBuilder);
        return signatureBuilder.build();
    }

    @Override
    public DSSDocument signDocument(DSSDocument document, XAdESSignatureParameters parameters, byte[] signatureValue) throws DSSException {
        return this.signDocument(Collections.singletonList(document), parameters, signatureValue);
    }

    @Override
    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, XAdESSignatureParameters parameters, byte[] signatureValue) {
        SignatureBuilder builder = parameters.getContext().getBuilder();
        builder = builder != null ? parameters.getContext().getBuilder() : XAdESSignatureBuilder.getSignatureBuilder(parameters, toSignDocuments, this.certificateVerifier);
        DSSDocument dssDocument = builder.signDocument(signatureValue);
        parameters.getContext().setBuilder(builder);
        return dssDocument;
    }

    static {
        SantuarioInitializer.init();
    }
}

