/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.tsl;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.definition.tsl.TrustedListNamespace;
import eu.europa.esig.dss.xades.tsl.TLStructureVerifier;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XAdESTrustedListUtils {
    public static final Integer TL_V5_IDENTIFIER = 5;
    public static final Integer TL_V6_IDENTIFIER = 6;
    public static final String TL_VERSION_IDENTIFIER_PATH = "./tl:SchemeInformation/tl:TSLVersionIdentifier";

    private XAdESTrustedListUtils() {
    }

    public static Integer getTSLVersionIdentifier(Document documentDom) {
        String tlVersionIdentifier;
        Element tlVersionIdentifierElement = DomUtils.getElement(documentDom.getDocumentElement(), TL_VERSION_IDENTIFIER_PATH);
        if (tlVersionIdentifierElement != null && (tlVersionIdentifier = tlVersionIdentifierElement.getTextContent()) != null && Utils.isStringDigits(tlVersionIdentifier)) {
            return Integer.valueOf(tlVersionIdentifier);
        }
        return null;
    }

    public static List<String> validateUnsignedTrustedList(DSSDocument tlDocument, int targetTLVersion) throws IllegalInputException {
        Objects.requireNonNull(tlDocument, "XML Trusted List cannot be null!");
        if (DomUtils.isDOM(tlDocument)) {
            Document documentDom = DomUtils.buildDOM(tlDocument);
            return XAdESTrustedListUtils.validateUnsignedTrustedList(documentDom, targetTLVersion);
        }
        return Collections.singletonList("The document is not XML!");
    }

    public static List<String> validateUnsignedTrustedList(Document documentDom, int targetTLVersion) throws IllegalInputException {
        Objects.requireNonNull(documentDom, "XML Trusted List cannot be null!");
        ArrayList<String> errorMessages = new ArrayList<String>();
        Integer tlVersionIdentifier = XAdESTrustedListUtils.getTSLVersionIdentifier(documentDom);
        if (tlVersionIdentifier == null) {
            errorMessages.add("No TSLVersionIdentifier has been found!");
        } else if (!tlVersionIdentifier.equals(targetTLVersion)) {
            errorMessages.add(String.format("TSL Version '%s' found in the XML Trusted List does not correspond to the target version defined by the builder '%s'! Please modify the document or change to the appropriate builder.", tlVersionIdentifier, targetTLVersion));
        } else {
            List<String> xsdErrors = new TLStructureVerifier().setSigningMode(true).setAcceptedTLVersions(Collections.singletonList(targetTLVersion)).validate(documentDom, (Integer)targetTLVersion);
            if (Utils.isCollectionNotEmpty(xsdErrors)) {
                errorMessages.addAll(xsdErrors);
            }
        }
        return errorMessages;
    }

    static {
        DomUtils.registerNamespace(TrustedListNamespace.NS);
    }
}

