/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.List;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.cff.DataInputByteArray;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFMtxEntry;
import org.apache.fop.fonts.truetype.OpenFont;
import org.apache.pdfbox.io.RandomAccessReadBuffer;

public class OTFFile
extends OpenFont {
    protected CFFFont fileFont;

    public OTFFile() throws IOException {
        this(true, false);
    }

    public OTFFile(boolean useKerning, boolean useAdvanced) throws IOException {
        super(useKerning, useAdvanced);
        this.checkForFontbox();
    }

    private void checkForFontbox() throws IOException {
        try {
            Class.forName("org.apache.fontbox.cff.CFFFont");
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("The Fontbox jar was not found in the classpath. This is required for OTF CFF ssupport.");
        }
    }

    @Override
    protected void updateBBoxAndOffset() throws IOException {
        Object bbox = this.fileFont.getTopDict().get("FontBBox");
        if (bbox != null) {
            List bboxList = (List)bbox;
            int[] bboxInt = new int[4];
            for (int i = 0; i < bboxInt.length; ++i) {
                bboxInt[i] = (Integer)bboxList.get(i);
            }
            for (OFMtxEntry o : this.mtxTab) {
                o.setBoundingBox(bboxInt);
            }
        }
    }

    @Override
    protected void initializeFont(FontFileReader in) throws IOException {
        this.fontFile = in;
        this.fontFile.seekSet(0L);
        CFFParser parser = new CFFParser();
        this.fileFont = parser.parse(new RandomAccessReadBuffer(in.getAllBytes())).get(0);
        this.embedFontName = this.fileFont.getName();
    }

    @Override
    protected void readName() throws IOException {
        Object familyName = this.fileFont.getTopDict().get("FamilyName");
        if (familyName != null && !familyName.equals("")) {
            this.familyNames.add(familyName.toString());
            this.fullName = familyName.toString();
        } else {
            this.fullName = this.fileFont.getName();
            this.familyNames.add(this.fullName);
        }
    }

    public static byte[] getCFFData(FontFileReader fontFile) throws IOException {
        byte[] cff = fontFile.getAllBytes();
        DataInputByteArray input = new DataInputByteArray(fontFile.getAllBytes());
        input.readBytes(4);
        int numTables = input.readShort();
        input.readShort();
        input.readShort();
        input.readShort();
        for (int q = 0; q < numTables; ++q) {
            String tagName = new String(input.readBytes(4));
            OTFFile.readLong(input);
            long offset = OTFFile.readLong(input);
            long length = OTFFile.readLong(input);
            if (!tagName.equals("CFF ")) continue;
            cff = new byte[(int)length];
            System.arraycopy(fontFile.getAllBytes(), (int)offset, cff, 0, cff.length);
            break;
        }
        return cff;
    }

    private static long readLong(DataInputByteArray input) throws IOException {
        return input.readUnsignedShort() << 16 | input.readUnsignedShort();
    }

    public boolean isType1() {
        return this.fileFont instanceof CFFType1Font;
    }

    private static class Mapping {
        private int sid;
        private String name;
        private byte[] bytes;

        private Mapping() {
        }

        public void setSID(int sid) {
            this.sid = sid;
        }

        public int getSID() {
            return this.sid;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

